/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.nether;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.SimpleLayerProvider;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class BYGNetherBiomeSource
extends BiomeProvider {
    public static final Codec<BYGNetherBiomeSource> BYGNETHERCODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGNetherBiomeSource::new)));
    private final DatapackLayer biomeLayer;
    private final long seed;
    private final Registry<Biome> biomeRegistry;
    public static List<ResourceLocation> NETHER_BIOMES = new ArrayList<ResourceLocation>();

    public BYGNetherBiomeSource(Registry<Biome> registry, long seed) {
        super(new ArrayList());
        this.seed = seed;
        this.biomeRegistry = registry;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        WeightedList biomes = new WeightedList();
        HashMap<ResourceLocation, WeightedList<ResourceLocation>> hills = new HashMap<ResourceLocation, WeightedList<ResourceLocation>>();
        HashMap<ResourceLocation, ResourceLocation> edges = new HashMap<ResourceLocation, ResourceLocation>();
        HashSet allBiomes = new HashSet();
        BiomeDataHolders.WeightedBiomeDataHolder netherData = BYG.getNetherData(gson, BYG.CONFIG_PATH.resolve("byg-nether-biomes.json"));
        Map biomeData = netherData.getBiomeData();
        biomeData.remove(null);
        biomeData.remove(BYG.EMPTY);
        biomeData.forEach((biome, endBiomeData) -> {
            biomes.func_226313_a_(biome, endBiomeData.getWeight());
            hills.put((ResourceLocation)biome, endBiomeData.getSubBiomes());
            ResourceLocation edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                edges.put((ResourceLocation)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(WeightedList.Entry::func_220647_b).collect(Collectors.toList()));
        });
        edges.remove(BYG.EMPTY);
        hills.remove(BYG.EMPTY);
        allBiomes.remove(BYG.EMPTY);
        edges.remove(null);
        hills.remove(null);
        allBiomes.remove(null);
        this.field_226837_c_.addAll(allBiomes.stream().filter(resourceLocation -> resourceLocation != null && !resourceLocation.equals((Object)BYG.EMPTY)).map(arg_0 -> registry.func_82594_a(arg_0)).collect(Collectors.toList()));
        this.biomeLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().netherBiomeSize, (WeightedList<ResourceLocation>)biomes, hills, edges);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BYGNETHERCODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BYGNetherBiomeSource(this.biomeRegistry, seed);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.biomeLayer.sampleNether(this.biomeRegistry, x, z);
    }
}

